/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2005 by Myricom, Inc.  All rights reserved.                 *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#if MX_OS_WINNT
#include <windows.h>
#include <winsock2.h>

MX_FUNC(int)
mx_gettimeofday (struct timeval* tv, void* tz)
{
#if 1
        static LARGE_INTEGER Frequency;
        LARGE_INTEGER CurrCounter;
        static int init = 0;
        FILETIME CurrentTime;
        static int UseHighResTimer = 1;
        LONGLONG tmp;
        tz = 0;

        if (!init) {
                if (!QueryPerformanceFrequency(&Frequency)) {
                        UseHighResTimer = 0;
                }
                init = 1;
        }
        if (!tv)
                return -1;

        if (UseHighResTimer) {
                GetSystemTimeAsFileTime(&CurrentTime);
                /* don't include any function overhead */
                QueryPerformanceCounter(&CurrCounter);

                CurrCounter.QuadPart *= 10000000;
                CurrCounter.QuadPart /= Frequency.QuadPart;

                CurrentTime.dwHighDateTime = CurrCounter.HighPart;
                CurrentTime.dwLowDateTime = CurrCounter.LowPart;
        } else {
                GetSystemTimeAsFileTime(&CurrentTime);
        }

        tmp = ((LONGLONG) CurrentTime.dwHighDateTime << 32);
        tmp += (LONGLONG) CurrentTime.dwLowDateTime;

        tv->tv_sec = (long) (tmp / 10000000);
        tv->tv_usec = (long) (tmp - ((LONGLONG)(tv->tv_sec) * 10000000)) / 10;

        return 0;
#else
  FILETIME ft;
  ULARGE_INTEGER base1601;
  ULARGE_INTEGER base1970;

  if (tv != NULL) {
    GetSystemTimeAsFileTime (&ft);
    base1601.LowPart = ft.dwLowDateTime;
    base1601.HighPart = ft.dwHighDateTime;
    base1970.QuadPart = base1601.QuadPart - 116444736000000000;
    tv->tv_sec = (long)(base1970.QuadPart / 10000000);
    tv->tv_usec = (long)((base1970.QuadPart % 10000000) / 10);
  }
  return 0;
#endif
}
#endif
